

set -euo pipefail


export OMP_NUM_THREADS=${SLURM_CPUS_PER_TASK}
export MKL_NUM_THREADS=${SLURM_CPUS_PER_TASK}

DATASETS=("breast" "digits" "iris" "wine" "diabetes")
TID=${SLURM_ARRAY_TASK_ID}
DS_IDX=$(( TID / 5 ))
SEED=$(( TID % 5 ))
DATASET=${DATASETS[$DS_IDX]}

echo "SLURM_ARRAY_TASK_ID=$TID -> DATASET=$DATASET SEED=$SEED"

python run_hypersense_single.py --dataset "$DATASET" --seed "$SEED"
